/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.client.render.infobar;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.toma.gunsrpg.client.render.infobar.DataRowElement;
import dev.toma.gunsrpg.client.render.infobar.IDataElement;
import dev.toma.gunsrpg.client.render.infobar.IDataModel;
import dev.toma.gunsrpg.client.render.infobar.QuestInfoElement;
import dev.toma.gunsrpg.client.render.infobar.TextElement;
import dev.toma.gunsrpg.common.quests.condition.NoConditionProvider;
import dev.toma.gunsrpg.common.quests.quest.Quest;
import dev.toma.gunsrpg.util.RenderUtils;
import dev.toma.gunsrpg.util.math.IDimensions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.text.ITextComponent;

public class QuestDisplayDataModel
implements IDataModel {
    private final List<IDataElement> list = new ArrayList<IDataElement>();
    private boolean resized;
    private int width;
    private int height;

    public void addQuestHeader(Quest<?> quest) {
        this.addQuestHeader(quest, true);
    }

    public void addQuestHeader(Quest<?> quest, boolean objective) {
        this.addElement(new QuestInfoElement(quest, objective));
    }

    public <Q extends Quest<?>> void addInformationRow(ITextComponent title, Q quest, Function<Q, ITextComponent> provider) {
        this.addElement(new DataRowElement<Q>(quest, title, provider));
    }

    public void addConditionDisplay(Quest<?> quest) {
        Arrays.stream(quest.getConditions()).filter(condition -> condition != NoConditionProvider.NO_CONDITION).sorted(Comparator.comparing(condition -> condition.getProviderType().getType().getId())).forEach(condition -> this.addElement(new TextElement(condition.getDescriptor(true))));
    }

    @Override
    public void addElement(IDataElement element) {
        this.list.add(element);
        this.resized = true;
    }

    @Override
    public void renderModel(MatrixStack matrix, FontRenderer font, int x, int y, boolean rightSided) {
        if (this.resized) {
            for (IDataElement element : this.list) {
                element.draw(matrix, font, x, y, this.width, this.height);
            }
            this.width = this.getWidth();
            this.height = this.getHeight();
            this.resized = false;
        }
        if (rightSided) {
            x -= this.width + 3;
        }
        int heightOffset = 0;
        RenderUtils.drawSolid(matrix.func_227866_c_().func_227870_a_(), x - 3, y - 3, x + this.width + 3, y + this.height + 3, 0x66000000);
        for (IDataElement element : this.list) {
            element.draw(matrix, font, x, y + heightOffset, this.width, this.height);
            heightOffset += element.getHeight();
        }
    }

    private int getWidth() {
        return this.list.stream().mapToInt(IDimensions::getWidth).max().orElse(0);
    }

    private int getHeight() {
        return this.list.stream().mapToInt(IDimensions::getHeight).reduce(Integer::sum).orElse(0);
    }
}

